C======================================================================
      SUBROUTINE USRBCC(VARIABLE,NODE1,NODE2,IELEM,NBCD,NDIE,RZ,
     &     DRZ,USRNOD,NUSRN,ENVTEM,TEMO,TEMC,CURTIM,MODEL,IMODE,ITYPE,
     &     NURZ)
C======================================================================
C
C     User defined boundary value
C
C     Input :
C
C     NODE1, NODE2 : edge node number (slave side)
C     MSNODE1, MSNODE2: edge node numbers (master side)
C     IELEM : element number it belong
C     NBCD(NURZ,2) : boundary condition code
C     NDIE : contact condition
C          0 : non-contact
C          n : contact to n object
C
C     RZ(2,2) : coordinate of nodes
C     DRZ(NURZ,2) : displacement of nodes      
C     USRNOD(NUSRN,I) : user defined node variables 
C        I : node number, user node1 and node2 to get the
C            values
C     NUSRN : number of user definde node variables
C     ENVTEM : environmental temperature or film temperature
C     TEMO(2) : previous step temperature
C     TEMC(2) : current step temperature     
C     CURTIM : currunt time 
C     MODEL : subroutine number (function number)
C     IMODE : simulation type
C        1  : deformation
C        2  : heat transfer
C        3  : diffusion
C     ITYPE : output type
C           IMODE = 1 
C              1 : pressure
C              2 : friction coefficient     
C           IMODE =2
C              1 : environmental temperature
C              2 : convection coefficient for free surface
C                  or lubricant coefficient for contact surface
C              3 : radiation coefficient
C              4 : heat flux
C           IMODE = 3
C              1 : environmental atom content
C              2 : surface reaction coefficient
C              3 : atom flux
C     NURZ  : number of degree of freedom in velocity and displacement 
C              2 : for axisymmetric and plane strain  
C              3 : for axisymmetric with angular velocity
C
C     Output :
C     
C     Variable : user defined boundary coefficient or value
C
C======================================================================
      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)      
c      COMMON /ZSTRCH/ STRCH    !  moved STRCH to common block UFHCOM2
      COMMON /UFHCOM2/ STRCH,EFSTS,EFEPS
      COMMON/MSNODE/MSNODE1,MSNODE2
      DIMENSION NBCD(NURZ,2),RZ(2,2),DRZ(NURZ,2),USRNOD(NUSRN,1),     
     &     TEMO(2),TEMC(2)
      
      GO TO (10,20), MODEL 
C     
 10   CALL UBCC1(VARIABLE,NODE1,NODE2,IELEM,NBCD,NDIE,RZ,
     &     DRZ,USRNOD,NUSRN,ENVTEM,TEMO,TEMC,CURTIM,IMODE,ITYPE,NURZ)
      RETURN
C
 20   CALL UBCC2(VARIABLE,NODE1,NODE2,IELEM,NBCD,NDIE,RZ,
     &     DRZ,USRNOD,NUSRN,ENVTEM,TEMO,TEMC,CURTIM,IMODE,ITYPE,NURZ)
      RETURN
C     
C  TO BE CONTINUED BY THE USER, IF NECESSARY
C
      END


C======================================================================
      SUBROUTINE UBCC1(VARIABLE,NODE1,NODE2,IELEM,NBCD,NDIE,RZ,
     &     DRZ,USRNOD,NUSRN,ENVTEM,TEMO,TEMC,CURTIM,IMODE,ITYPE,NURZ)
C======================================================================
C
C     User defined boundary condition 
C
C======================================================================
      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C    
C     TMPENV: Interpolated Master Temperature
C     TMPSLF: Interpolated Slave Temperature
C     SLDVEL: Sliding VElocity
C     STRCH : Surface stretch on slave side
C     PRESSN: Pressure
C     EFSTS : Effective stress
C     EFEPS : Effective strain rate (not available)
C
      COMMON /UFHCOM/ TMPENV,TMPSLF,SLDVEL,PRESS
      COMMON /UFHCOM2/ STRCH,EFSTS,EFEPS
      COMMON/MSNODE/MSNODE1,MSNODE2
C     
      DIMENSION NBCD(NURZ,2),RZ(2,2),DRZ(NURZ,2),USRNOD(NUSRN,1),     
     &     TEMO(2),TEMC(2)
      DIMENSION USRND1(100),USRND2(100)
      VARIABLE=0.0
C
C     copy user variables
C
      DO I=1,NUSRN
         USRND1(I)=USRNOD(I,NODE1)
         USRND2(I)=USRNOD(I,NODE2)
      ENDDO
C
C     define pressure value
C      
C     IMODE=1, ITYPE=1
C

      IF(IMODE.EQ.1) THEN
         IF(ITYPE.EQ.1) THEN
C
C        Assuming Pressure is a function of time  
C
            PRESSURE=1.0*CURTIM
            VARIABLE=PRESSURE
         ENDIF
C
C        USER DEFINED FRCITION FACTOR
C
         IF (ITYPE.EQ.2) THEN
C
C        Assuming The Friction Factor is a constant (0.2)
C
	    FRCFAC = 0.2
            VARIABLE=FRCFAC
         ENDIF
      ENDIF
C
C     define heat flux value
C
C     IMODE=2, ITYPE=4
C
      IF(IMODE.EQ.2) THEN
         IF(ITYPE.EQ.4) THEN
C
C        Assuming Heat flux is a function of time
C
	    HFLUX=1.0*CURTIM
            VARIABLE=HFLUX
         ENDIF
      ENDIF      
C
C     user can define other coefficient and value in same way
C
      RETURN
      END
C======================================================================
      SUBROUTINE UBCC2(VARIABLE,NODE1,NODE2,IELEM,NBCD,NDIE,RZ,
     &     DRZ,USRNOD,NUSRN,ENVTEM,TEMO,TEMC,CURTIM,IMODE,ITYPE,NURZ)
C======================================================================
C
C     User defined boundary condition 
C
C======================================================================
      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)

      VARIABLE=0.0

      RETURN
      END
C======================================================================
      SUBROUTINE USRBCC2(VARIABLE,NODE1,NODE2,IELEM,NBCD,NDIE,RZ,
     &     DRZ,USRNOD,NUSRN,ENVTEM,TEMO,TEMC,CURTIM,MODEL,IMODE,ITYPE,
     &     NURZ,URZ,USRELE,NUSRE,STRAN,NSTRN,PRESS,CONCDS,HICAPAS,
     *     CONCDM,HICAPAM,DTMAXC)
C======================================================================
C
C     User defined boundary value
C
C     Input :
C
C     NODE1, NODE2 : edge node number
C     IELEM : element number it belong
C     NBCD(NURZ,2) : boundary condition code
C     NDIE : contact condition
C          0 : non-contact
C          n : contact to n object
C
C     RZ(2,2) : coordinate of nodes
C     DRZ(NURZ,2) : displacement of nodes      
C*     URZ(NURZ,2) : displacement of nodes      
C     USRNOD(NUSRN,I) : user defined node variables 
C        I : node number, use node1 and node2 to get the
C            values
C     NUSRN : number of user definde node variables
C*     USRELE(NUSRE,IELEM) : user defined element variables 
C        I : element number, use IELEM to get the values
C*     NUSRE : number of user definde element variables
C*    STRAN(LSTSR,IELEM) : strain components 
C*    LSTSR : number of strain components
C*    PRESS : nodal pressure
C*    CONCDS : conductivity for slave (workpiec)
C*    HICAPAS : heat capacity for slave (workpiece)
C*    CONCDM : conductivity for master ( die )
C*    HICAPAM : heat capacity master (die ) 
C     ENVTEM : environmental temperature or film temperature
C     TEMO(2) : previous step temperature
C     TEMC(2) : current step temperature     
C     CURTIM : currunt time 
C     MODEL : subroutine number (function number)
C     IMODE = 2 : simulation type heat transfer
C     ITYPE = 2  : output type lubricant coefficianet
C     NURZ  : number of degree of freedom in velocity and displacement 
C              2 : for axisymmetric and plane strain  
C              3 : for axisymmetric with angular velocity
C
C     /USRCTL/  KOBJ,ISTATUS,KSTEP,KSSTEP
C
C     KSTEP : number of step
C     KSSTEP : negative step indicator -1 for negative step or 1
C
C     Output :
C     
C     Variable : user defined boundary coefficient or value
C
C======================================================================
      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)      
      
      COMMON /USRCTL/ KOBJ,ISTATUS,KSTEP,KSSTEP

      DIMENSION NBCD(NURZ,2),RZ(2,2),DRZ(NURZ,2),USRNOD(NUSRN,*),     
     &     TEMO(2),TEMC(2),USRELE(NUSRE,*),STRAN(NSTRN,*),PRESS(2,*)
     
      VARIABLE = 1.0
      XMID =  ( RZ(1,1) + RZ(1,2) ) / 2.0D0
      VARIABLE = XMID

      WRITE(*,*) KSTEP, KSSTEP, KSTEP*KSSTEP

      RETURN
      END

C======================================================================
